## Component Context

You may find that you have no idea how to enter custom context for callbacks. We provide a simple way to do this. by using ```set_flow_event_context_creator``` in component, all contexts of parents of your component will be entered when callback is called.

**WRANING** only support access context variable saved in ```contextvars.ContextVar```, because we run callback in ```asyncio.Task```.

```Python

from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
import contextlib
import io 
from typing import Optional
import contextvars
CTX_VAR: contextvars.ContextVar[Optional[str]] = contextvars.ContextVar("context", default=None)

@contextlib.contextmanager
def enter_conetxt(msg: str):
    token = CTX_VAR.set(msg)
    try:
        yield 
    finally:
        CTX_VAR.reset(token)

class App:
    @mark_create_layout
    def my_layout(self):
        self.md = mui.Markdown()
        capture_box = mui.HBox([
            mui.Button("Click", self._on_click),
            self.md,
        ])
        # set context creator
        capture_box.set_flow_event_context_creator(lambda: enter_conetxt("ContextVars Variable"))
        return mui.VBox([
            mui.Typography("Hello Component Context"),
            capture_box,
        ])

    async def _on_click(self):
        await self.md.write(CTX_VAR.get())


```